implementation module windowcreate


//	Object I/O library, version 1.0.1

//	Window creation


import StdBool, StdTuple, StdList, StdMisc
import oswindow
import StdMenu, StdPSt
import commondef, controlcreate, iostate, ospicture, scheduler, windowaccess, windowclipstate, windowdefaccess, windowupdate, windowvalidate


/*	Open a modeless window/dialogue.
*/
openwindow :: !Id !(WindowLSHandle .ls (PSt .l .p)) !(PSt .l .p) -> PSt .l .p
openwindow wId {wlsState,wlsHandle} pState=:{io=ioState}
	= pState2
where
	(wDevice,ioState1)		= IOStGetDevice WindowDevice ioState
	windows					= WindowSystemStateGetWindowHandles wDevice
	(wPtr,index,wlsHandle1,windows1,ioState2)
							= openAnyWindow wId wlsHandle windows ioState1
	(windowInit,wlsHandle2)	= getWindowHandleInit wlsHandle1
	wlsH					= {wlsState=ls1,wlsHandle=wlsHandle2}
	wIds					= {wId=wId,wPtr=wPtr}
	wsH						= {wshIds=wIds,wshHandle=Just wlsH}
	windows2				= addWindowHandlesWindow index wsH windows1
	pState1					= {pState & io=IOStSetDevice (WindowSystemState windows2) ioState2}
	(ls1,pState2)			= seq windowInit (wlsState,pState1)

getWindowHandleInit :: !(WindowHandle .ls .ps) -> (![IdFun *(.ls,.ps)],!WindowHandle .ls .ps)
getWindowHandleInit wH=:{whAtts}
	= (getwindowinit (snd (Select iswindowinit (WindowInit []) whAtts)),wH)


/*	Open a modal dialog.
	This function does not yet create a true modal dialog. 
*/
openmodalwindow :: !Id !(WindowLSHandle .ls (PSt .l .p)) !(PSt .l .p) -> PSt .l .p
openmodalwindow wId {wlsState,wlsHandle} pState=:{io=ioState}
	= pState4
where
	(wDevice,ioState1)							= IOStGetDevice WindowDevice (disableMenuSystem ioState)	// PA: disableMenuSystem added
	windows										= WindowSystemStateGetWindowHandles wDevice
	((modalWIDS,windows1),ioState2)				= accIOToolbox (disableWindowSystem windows) ioState1
	(wPtr,index,wlsHandle1,windows2,ioState3)	= openAnyWindow wId wlsHandle windows1 ioState2
	(windowInit,wlsHandle2)						= getWindowHandleInit wlsHandle1
	wlsH										= {wlsState=ls1,wlsHandle=wlsHandle2}
	wIds										= {wId=wId,wPtr=wPtr}
	wsH											= {wshIds=wIds,wshHandle=Just wlsH}
	windows3									= addWindowHandlesWindow index wsH windows2
	(ioId,ioState4)								= IOStGetIOId ioState3
	ioState5									= IOStSetIOIsModal (Just ioId) ioState4
	pState1										= {pState & io=IOStSetDevice (WindowSystemState windows3) ioState5}
	(ls1,pState2)								= StrictSeq windowInit (wlsState,pState1)
	pState3										= whileCondDoIO (modalCond wId) pState2
	pState4										= enableProperWindows modalWIDS pState3
	
	enableProperWindows :: !(Maybe WIDS) !(PSt .l .p) -> PSt .l .p
	enableProperWindows modalWIDS pState
		# (closed,pState)		= accPIO IOStClosed pState
		| closed
			= pState
		# (wDevice,ioState)		= IOStGetDevice WindowDevice pState.io
		  windows				= WindowSystemStateGetWindowHandles wDevice
		# (windows,ioState)		= accIOToolbox (enableWindowSystem modalWIDS windows) ioState
		# (stillModal,windows)	= existsModalWindow windows
		# ioState				= IOStSetDevice (WindowSystemState windows) ioState
		| stillModal
			= {pState & io=ioState}
			= {pState & io=enableMenuSystem (IOStSetIOIsModal Nothing ioState)}	// PA: enableMenuSystem added
	
	existsModalWindow :: !(WindowHandles .ps) -> (!Bool,!WindowHandles .ps)
	existsModalWindow windows
		# (ok,wids,windows)	= getWindowHandlesActiveWindow windows
		| not ok
		= (False,windows)
		# (_,wsH,windows)	= getWindowHandlesWindow (toWID wids.wId) windows
		  (wMode,wsH)		= getWindowStateHandleWindowMode wsH
		  windows			= setWindowHandlesWindow wsH windows
		= (wMode==Modal,windows)
	
	modalCond :: !Id !Context -> (!Bool,!Context)
	modalCond modalWindowId context=:{cGroups,cModalProcess=Just myId}
		# ((found,running),groups)	= gGroups modalWindowId myId cGroups
		# context					= {context & cGroups=groups}
		| not found
		= (False,context)
		= (fromJust running,context)
	where
		gGroups :: !Id !SystemId !*Groups -> (!Result Bool,!*Groups)
		gGroups modalWindowId id groups
			= accessGroups (f` modalWindowId id) groups
		where
			f` modalWindowId id {groupState=p,groupIO=locals}
				# (r,locals) = gLocals modalWindowId id locals
				= (r,{groupState=p,groupIO=locals})
		
		gLocals :: !Id !SystemId !*(Locals .p) -> (!Result Bool,!*Locals .p)
		gLocals modalWindowId id locals
			= accessLocals (checkIOStRunning modalWindowId id) locals
		where
			checkIOStRunning modalWindowId id localIO=:{localIOSt=ioState}
				# (r,ioState)	= checkRunning modalWindowId id ioState
				= (r,{localIO & localIOSt=ioState})
			where
				checkRunning :: !Id !SystemId !(IOSt .l .p) -> (!Result Bool,!IOSt .l .p)
				checkRunning modalWindowId ioid ioState
					# (ioid`,ioState)		= IOStGetIOId ioState
					| ioid<>ioid`
					= ((False,Nothing),ioState)
					# (closed,ioState)		= IOStClosed ioState
					| closed
					= ((True,Just False),ioState)
					# (wDevice,ioState)		= IOStGetDevice WindowDevice ioState
					  wsHs					= WindowSystemStateGetWindowHandles wDevice
					  (found,wsH,wsHs)		= getWindowHandlesWindow (toWID modalWindowId) wsHs
					| not found
					= ((True,Just False),IOStSetDevice (WindowSystemState wsHs) ioState)
					# (wMode,wsH)			= getWindowStateHandleWindowMode wsH
					  wsHs					= setWindowHandlesWindow wsH wsHs
					= ((True,Just (wMode==Modal)),IOStSetDevice (WindowSystemState wsHs) ioState)
	modalCond _ context
		= (False,context)



/*	openAnyWindow creates a window.
		After validating the window and its controls, the window and its controls are created.
		The return OSWindowPtr is the OSWindowPtr of the newly created window.
		The return Index is the proper insert position in the WindowHandles list.
*/
openAnyWindow :: !Id !(WindowHandle .ls (PSt .l .p)) !(WindowHandles (PSt .l .p)) !(IOSt .l .p)
	-> (!OSWindowPtr,!Index,!WindowHandle .ls (PSt .l .p),!WindowHandles (PSt .l .p),!IOSt .l .p)
openAnyWindow wId wH windows ioState
	# (tb,ioState)					= getIOToolbox ioState
	# (index,pos,size,wH,windows,tb)= validateWindow wH windows tb
	# (delay_info,wPtr,wH,tb)		= createAnyWindow wId pos size wH tb		// PA: (de)activates for the time being ignored.
	# (wH,tb)						= validateWindowClipState wPtr wH tb
	  (behindPtr,windows)			= getStackBehindWindow index windows
	# tb							= stackWindow wPtr behindPtr tb
	# ioState						= setIOToolbox tb ioState
	= (wPtr,index,wH,windows,ioState)

createAnyWindow :: !Id !Point !Size !(WindowHandle .ls (PSt .l .p)) !*OSToolbox
	 -> (![DelayActivationInfo],!OSWindowPtr,!WindowHandle .ls (PSt .l .p), !*OSToolbox)
createAnyWindow wId {x,y} {w,h} wH=:{whMode,whKind,whTitle,whWindowInfo,whAtts} tb
	| whKind==IsWindow
		# (delay_info,wPtr,hPtr,vPtr,wH,tb)
						= OScreateWindow isResizable hInfo vInfo (SizeToTuple minSize) (SizeToTuple maxSize)
										 isClosable whTitle pos size getWindowHandleDefaultPtr createWindowControls (updateWindowControl wId (w,h))
										 wH tb
		  windowInfo	= {	windowInfo	& windowHScroll	= setScrollInfoPtr hScroll hPtr
		  								, windowVScroll	= setScrollInfoPtr vScroll vPtr
		  				  }
		  wH			= {wH & whWindowInfo=Just windowInfo}
		= (delay_info,wPtr,wH,tb)
		with
			isResizable	= Contains iswindowresize whAtts
			windowInfo	= fromJust whWindowInfo
			viewDomain	= windowInfo.windowDomain
			viewOrigin	= windowInfo.windowOrigin
			hScroll		= windowInfo.windowHScroll
			vScroll		= windowInfo.windowVScroll
			hInfo		= toScrollbarInfo hScroll (viewDomain.corner1.x,viewOrigin.x,viewDomain.corner2.x,w)
			vInfo		= toScrollbarInfo vScroll (viewDomain.corner1.y,viewOrigin.y,viewDomain.corner2.y,h)
			minSize		= getwindowminimumsize (snd (Select iswindowminimumsize undef whAtts))
			maxSize		= rectangleSize viewDomain
			
			toScrollbarInfo :: !(Maybe ScrollInfo) (Int,Int,Int,Int) -> ScrollbarInfo
			toScrollbarInfo Nothing scrollState
						= {cbiHasScroll=False,cbiPos=undef,cbiSize=undef,cbiState=undef}
			toScrollbarInfo (Just {scrollItemPos,scrollItemSize}) scrollState
						= {cbiHasScroll=True,cbiPos=(scrollItemPos.x,scrollItemPos.y),cbiSize=(scrollItemSize.w,scrollItemSize.h),cbiState=scrollState}
			
			setScrollInfoPtr :: !(Maybe ScrollInfo) !OSWindowPtr -> Maybe ScrollInfo
			setScrollInfoPtr (Just info) scrollPtr
				= Just {info & scrollItemPtr=scrollPtr}
			setScrollInfoPtr nothing _
				= nothing
	= OScreateDialog isModal 
					 isClosable whTitle pos size getWindowHandleDefaultPtr createWindowControls (updateWindowControl wId (w,h))
					 wH tb
	with
		isModal		= whMode==Modal
where
	isClosable		= Contains iswindowclose whAtts
	pos				= (x,y)
	size			= (w,h)
	
	// getWindowHandleDefaultPtr retrieves the OSWindowPtr to the Ok control
	getWindowHandleDefaultPtr :: !(WindowHandle .ls .ps) -> (!OSWindowPtr,!WindowHandle .ls .ps)
	getWindowHandleDefaultPtr wH=:{whItems=itemHs}
		# (found,itemPtr,itemHs)	= getWElementHandlesDefaultPtr itemHs
		= (if found itemPtr OSNoWindowPtr,{wH & whItems=itemHs})
	where
		getWElementHandlesDefaultPtr :: ![WElementHandle .ls .ps] -> (!Bool,!OSWindowPtr,![WElementHandle .ls .ps])
		getWElementHandlesDefaultPtr [itemH:itemHs]
			# (found,itemPtr,itemH)	= getWElementHandleDefaultPtr itemH
			| found
			= (found,itemPtr,[itemH:itemHs])
			# (found,itemPtr,itemHs)= getWElementHandlesDefaultPtr itemHs
			= (found,itemPtr,[itemH:itemHs])
		where
			getWElementHandleDefaultPtr :: !(WElementHandle .ls .ps) -> (!Bool,!OSWindowPtr,!WElementHandle .ls .ps)
			getWElementHandleDefaultPtr (WListLSHandle itemHs)
				# (found,itemPtr,itemHs)	= getWElementHandlesDefaultPtr itemHs
				= (found,itemPtr,WListLSHandle itemHs)
			getWElementHandleDefaultPtr (WExtendLSHandle wExH=:{wExtendItems=itemHs})
				# (found,itemPtr,itemHs)	= getWElementHandlesDefaultPtr itemHs
				= (found,itemPtr,WExtendLSHandle {wExH & wExtendItems=itemHs})
			getWElementHandleDefaultPtr (WChangeLSHandle wChH=:{wChangeItems=itemHs})
				# (found,itemPtr,itemHs)	= getWElementHandlesDefaultPtr itemHs
				= (found,itemPtr,WChangeLSHandle {wChH & wChangeItems=itemHs})
			getWElementHandleDefaultPtr (WItemHandle itemH)
				| itemH.wItemKind==IsEditControl
				= (True,itemH.wItemPtr,WItemHandle itemH)
				= (False,OSNoWindowPtr,WItemHandle itemH)
		getWElementHandlesDefaultPtr _
			= (False,OSNoWindowPtr,[])
	
	// createWindowControls creates the controls.
	createWindowControls :: !OSWindowPtr !(WindowHandle .ls (PSt .l .p)) !*OSToolbox -> (!WindowHandle .ls (PSt .l .p),!*OSToolbox)
	createWindowControls wPtr wH=:{whDefaultId,whSelect,whItems=itemHs} tb
		# (itemHs,tb)	= createControls whDefaultId whSelect wPtr itemHs tb
		= ({wH & whItems=itemHs},tb)
	
	// updateWindowControl updates customised controls.
	updateWindowControl :: !Id !(!Int,!Int) !OSWindowPtr !OSWindowPtr !OSPictContext !(WindowHandle .ls (PSt .l .p)) !*OSToolbox
																				  -> (!WindowHandle .ls (PSt .l .p), !*OSToolbox)
	updateWindowControl wId (w,h) wPtr cPtr osPict wH=:{whItems=itemHs} tb
		#! (_,controls)	= getUpdateControls cPtr (0,0,w,h) itemHs
		#! wH			= {wH & whItems=itemHs}
		# updateInfo	= {	updWIDS			= {wPtr=wPtr,wId=wId}
						  ,	updWindowArea	= ZeroRect
						  ,	updControls		= controls
						  ,	updGContext		= Just osPict
						  }
		= updatewindow updateInfo wH tb
	where
		getUpdateControls :: !OSWindowPtr !Rect ![WElementHandle .ls .ps] -> (!Bool,![ControlUpdateInfo])
		getUpdateControls cPtr clipRect [itemH:itemHs]
			# (found,controls)	= getUpdateControl cPtr clipRect itemH
			| found
			= (found,controls)
			= getUpdateControls cPtr clipRect itemHs
		where
			getUpdateControl :: !OSWindowPtr !Rect !(WElementHandle .ls .ps) -> (!Bool,![ControlUpdateInfo])
			getUpdateControl cPtr clipRect (WListLSHandle itemHs)
				= getUpdateControls cPtr clipRect itemHs
			getUpdateControl cPtr clipRect (WExtendLSHandle wExH=:{wExtendItems=itemHs})
				= getUpdateControls cPtr clipRect itemHs
			getUpdateControl cPtr clipRect (WChangeLSHandle wExH=:{wChangeItems=itemHs})
				= getUpdateControls cPtr clipRect itemHs
			getUpdateControl cPtr clipRect (WItemHandle itemH=:{wItemPtr})
				| cPtr==wItemPtr
				= (True, [{cuItemNr=itemH.wItemNr,cuItemPtr=wItemPtr,cuArea=clipRect1}])
				= getUpdateControls cPtr clipRect1 itemH.wItems
			where
				clipRect1	= IntersectRects clipRect (PosSizeToRect itemH.wItemPos itemH.wItemSize)
		getUpdateControls _ _ _
			= (False,[])

getStackBehindWindow :: !Index !(WindowHandles .ps) -> (!OSWindowPtr,!WindowHandles .ps)
getStackBehindWindow 0 wsHs
	= (OSNoWindowPtr,wsHs)
getStackBehindWindow index wsHs=:{whsWindows}
	# (before,[wlsH=:{wshIds={wPtr}}:wlsHs])	= splitAt (index-1) whsWindows
	= (wPtr,{wsHs & whsWindows=before++[wlsH:wlsHs]})

stackWindow :: !OSWindowPtr !OSWindowPtr !*OSToolbox -> *OSToolbox
stackWindow wPtr OSNoWindowPtr tb
	= tb
stackWindow wPtr behindPtr tb
	= OSstackWindow wPtr behindPtr tb
